<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Pro_Slider_WP_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'pro_slider_wp_widget',
            'ProSlider WP',
            array( 'description' => 'Ayarladığınız ProSlider WP slider\'ını gösterir.' )
        );
    }

    public function widget( $args, $instance ) {
        echo $args['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }
        echo pro_slider_wp_display();
        echo $args['after_widget'];
    }

    public function form( $instance ) {
        $title = ! empty( $instance['title'] ) ? $instance['title'] : '';
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">Başlık:</label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
        <p>Tüm slider ayarları, eklentinin kendi <a href="admin.php?page=pro_slider_wp">ayar sayfasından</a> yönetilir.</p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        return $instance;
    }
}

function register_pro_slider_wp_widget() {
    register_widget( 'Pro_Slider_WP_Widget' );
}
add_action( 'widgets_init', 'register_pro_slider_wp_widget' );